*******************************************************************************
*                         680xx Grundprogramm Menue                           *
*                         (C) 1990 Ralph Dombrowski                           *
*                             2008 Jens Mewes                                 *
*                                 Rev 7.10                                    *
*                                01.01.2008                                   *
*                              Mensteuerung                                  *
*******************************************************************************


grund:                          * Menpunkte aufrufen
 movem.l d0-d7/a0-a6,-(a7)      * Register retten
 move.b menflag(a5),-(a7)       * menflag auch
 tst d0
 bmi.s grund1                   * d0 negativ bedeutet eine bestimmte Routine
 or.b #%10000100,d0             * Bits in menflag setzen
 move.b d0,menflag(a5)          *
 bsr smenue                     * Mensteuerung aufrufen
bra.s grund2                    * Ende

grund1:
 bclr.b #7,menflag(a5)          * Keine Hardcopy bei Einzelprogrammen
 neg d0                         * Negieren
 subq #1,d0                     * Bereich 1..33
 cmp #maxgrund,d0
 bhi.s grund2                   * Zu gro, kein Programm
 add d0,d0
 move grundtab(pc,d0),d0
 jsr grundtab(pc,d0)            * Programm aufrufen, da Adressberechnung OK
grund2:
 move.b (a7)+,menflag(a5)       * menflag zurck
 movem.l (a7)+,d0-d7/a0-a6      * Register zurck
rts

grundtab:                       * d0 = -X
 dc.w aendere-grundtab          * 1
 dc.w startex-grundtab          * 2
 dc.w speicheraus-grundtab      * 3
 dc.w symbolaus-grundtab        * 4
 dc.w edit-grundtab             * 5
 dc.w mass-grundtab             * 6
 dc.w bibo-grundtab             * 7
 dc.w savedisk-grundtab         * 8
 dc.w loaddisk-grundtab         * 9
 dc.w inhdisk-grundtab          * 10
 dc.w deldatei-grundtab         * 11
 dc.w kopdatei-grundtab         * 12
 dc.w rendatei-grundtab         * 13
 dc.w boot-grundtab             * 14
 dc.w promwrite-grundtab        * 15
 dc.w promread-grundtab         * 16
 dc.w ausspber-grundtab         * 17
 dc.w druckmen-grundtab         * 18
 dc.w ioread-grundtab           * 19
 dc.w iowrite-grundtab          * 20
 dc.w einzel-grundtab           * 21
 dc.w sysmen-grundtab           * 22
 dc.w textalt-grundtab          * 23
 dc.w textneu-grundtab          * 24
 dc.w symloe-grundtab           * 25
 dc.w groess21-grundtab         * 26
 dc.w groess11-grundtab         * 27
 dc.w debugein-grundtab         * 28
 dc.w debugaus-grundtab         * 29
 dc.w erraus-grundtab           * 30
 dc.w crtex-grundtab            * 31
 dc.w lstex-grundtab            * 32
 dc.w lstolf-grundtab           * 33

grundtend:

maxgrund equ (grundtend-grundtab)/2

start:                          * Grundprogramm Start beim Einschalten / Reset
 tst.b $7000.w                  * BOOT-Karte lschen
 move.l cpuwert(pc), d0
 cmp.l #1, d0
 bne.s start01
 move.b #$80,bankboot.w         * BANKBOOT-Karte lschen 68008
 bra.s start02
start01:
 move.w #$8080,bankboot.w       * Beide BANKBOOT-Karten lschen 68000
start02:
 lea basis(pc),a5
 adda.l ramstart(pc),a5         * a5 als Zeiger auf Variablen setzen
 lea stack(a5),a7               * Dummy Stack
 bsr init                       * Variablen init / Copyright ausgeben
 movea.l d0,a7                  * Stack festlegen
warmstart:
 cmp.l #$a140557a,bootflag(a5)
 beq.s smenue                   * Wenn Computer schon an war, dann weiter
 move.l #$a140557a,bootflag(a5) * Flag, da Computer an ist
 btst.b #1,keydil(a5)           * DIL-Schalter 1 auf Key angeschaltet ?
 beq.s smenue                   * Nein, dann normaler Start
 bsr autoboot                   * Ja, dann mit Autoboot beginnen

                                                                                                                                                                                        